@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Event Subscription
 * @property deadLetterDestination The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deadLetterWithResourceIdentity The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deliveryWithResourceIdentity Information about the destination where events have to be delivered for the event subscription.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property destination Information about the destination where events have to be delivered for the event subscription.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property eventDeliverySchema The event delivery schema for the event subscription.
 * @property expirationTimeUtc Expiration time of the event subscription.
 * @property filter Information about the filter for the event subscription.
 * @property id Fully qualified identifier of the resource.
 * @property labels List of user defined labels.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the event subscription.
 * @property retryPolicy The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
 * @property systemData The system metadata relating to Event Subscription resource.
 * @property topic Name of the topic of the event subscription.
 * @property type Type of the resource.
 */
public data class GetDomainTopicEventSubscriptionResult(
    public val deadLetterDestination: StorageBlobDeadLetterDestinationResponse? = null,
    public val deadLetterWithResourceIdentity: DeadLetterWithResourceIdentityResponse? = null,
    public val deliveryWithResourceIdentity: DeliveryWithResourceIdentityResponse? = null,
    public val destination: Any? = null,
    public val eventDeliverySchema: String? = null,
    public val expirationTimeUtc: String? = null,
    public val filter: EventSubscriptionFilterResponse? = null,
    public val id: String,
    public val labels: List<String>? = null,
    public val name: String,
    public val provisioningState: String,
    public val retryPolicy: RetryPolicyResponse? = null,
    public val systemData: SystemDataResponse,
    public val topic: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetDomainTopicEventSubscriptionResult): GetDomainTopicEventSubscriptionResult = GetDomainTopicEventSubscriptionResult(
            deadLetterDestination = javaType.deadLetterDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.StorageBlobDeadLetterDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deadLetterWithResourceIdentity = javaType.deadLetterWithResourceIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.DeadLetterWithResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deliveryWithResourceIdentity = javaType.deliveryWithResourceIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryWithResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            eventDeliverySchema = javaType.eventDeliverySchema().map({ args0 -> args0 }).orElse(null),
            expirationTimeUtc = javaType.expirationTimeUtc().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            retryPolicy = javaType.retryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.RetryPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topic = javaType.topic(),
            type = javaType.type(),
        )
    }
}
