@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Domain Topic.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the domain topic.
 * @property systemData The system metadata relating to Domain Topic resource.
 * @property type Type of the resource.
 */
public data class GetDomainTopicResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetDomainTopicResult): GetDomainTopicResult = GetDomainTopicResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
