@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Full endpoint URL of an event subscription
 * @property endpointUrl The URL that represents the endpoint of the destination of an event subscription.
 */
public data class GetNamespaceTopicEventSubscriptionFullUrlResult(
    public val endpointUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetNamespaceTopicEventSubscriptionFullUrlResult): GetNamespaceTopicEventSubscriptionFullUrlResult =
            GetNamespaceTopicEventSubscriptionFullUrlResult(
                endpointUrl = javaType.endpointUrl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
