@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * EventGrid Partner Namespace.
 * @property disableLocalAuth This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the partner namespace.
 * @property endpoint Endpoint for the partner namespace.
 * @property id Fully qualified identifier of the resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property location Location of the resource.
 * @property name Name of the resource.
 * @property partnerRegistrationFullyQualifiedId The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes the following format:
 * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
 * @property partnerTopicRoutingMode This determines if events published to this partner namespace should use the source attribute in the event payload
 * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
 * @property privateEndpointConnections
 * @property provisioningState Provisioning state of the partner namespace.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" />
 * @property systemData The system metadata relating to Partner Namespace resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetPartnerNamespaceResult(
    public val disableLocalAuth: Boolean? = null,
    public val endpoint: String,
    public val id: String,
    public val inboundIpRules: List<InboundIpRuleResponse>? = null,
    public val location: String,
    public val name: String,
    public val partnerRegistrationFullyQualifiedId: String? = null,
    public val partnerTopicRoutingMode: String? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPartnerNamespaceResult): GetPartnerNamespaceResult = GetPartnerNamespaceResult(
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            inboundIpRules = javaType.inboundIpRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            partnerRegistrationFullyQualifiedId = javaType.partnerRegistrationFullyQualifiedId().map({ args0 ->
                args0
            }).orElse(null),
            partnerTopicRoutingMode = javaType.partnerTopicRoutingMode().map({ args0 -> args0 }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
