@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Information about a partner registration.
 * @property id Fully qualified identifier of the resource.
 * @property location Location of the resource.
 * @property name Name of the resource.
 * @property partnerRegistrationImmutableId The immutableId of the corresponding partner registration.
 * Note: This property is marked for deprecation and is not supported in any future GA API version
 * @property provisioningState Provisioning state of the partner registration.
 * @property systemData The system metadata relating to Partner Registration resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetPartnerRegistrationResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val partnerRegistrationImmutableId: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPartnerRegistrationResult): GetPartnerRegistrationResult = GetPartnerRegistrationResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            partnerRegistrationImmutableId = javaType.partnerRegistrationImmutableId().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
