@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property groupIds GroupIds from the private link service resource.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property privateEndpoint The Private Endpoint resource for this Connection.
 * @property privateLinkServiceConnectionState Details about the state of the connection.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 * @property type Type of the resource.
 */
public data class GetPrivateEndpointConnectionResult(
    public val groupIds: List<String>? = null,
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: ConnectionStateResponse? = null,
    public val provisioningState: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPrivateEndpointConnectionResult): GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.ConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
