@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * EventGrid System Topic.
 * @property id Fully qualified identifier of the resource.
 * @property identity Identity information for the resource.
 * @property location Location of the resource.
 * @property metricResourceId Metric resource id for the system topic.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the system topic.
 * @property source Source for the system topic.
 * @property systemData The system metadata relating to System Topic resource.
 * @property tags Tags of the resource.
 * @property topicType TopicType for the system topic.
 * @property type Type of the resource.
 */
public data class GetSystemTopicResult(
    public val id: String,
    public val identity: IdentityInfoResponse? = null,
    public val location: String,
    public val metricResourceId: String,
    public val name: String,
    public val provisioningState: String,
    public val source: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val topicType: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetSystemTopicResult): GetSystemTopicResult = GetSystemTopicResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            metricResourceId = javaType.metricResourceId(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            topicType = javaType.topicType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
