@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Topic space resource.
 * @property description Description for the Topic Space resource.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the TopicSpace resource.
 * @property systemData The system metadata relating to the TopicSpace resource.
 * @property topicTemplates The topic filters in the topic space.
 * Example: "topicTemplates": [
 *               "devices/foo/bar",
 *               "devices/topic1/+",
 *               "devices/${principal.name}/${principal.attributes.keyName}" ].
 * @property type Type of the resource.
 */
public data class GetTopicSpaceResult(
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val topicTemplates: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetTopicSpaceResult): GetTopicSpaceResult = GetTopicSpaceResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topicTemplates = javaType.topicTemplates().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
