@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The identity information for the resource.
 * @property principalId The principal ID of resource identity.
 * @property tenantId The tenant ID of resource.
 * @property type The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
 * @property userAssignedIdentities The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 * This property is currently not used and reserved for future usage.
 */
public data class IdentityInfoResponse(
    public val principalId: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserIdentityPropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.IdentityInfoResponse): IdentityInfoResponse = IdentityInfoResponse(
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.eventgrid.kotlin.outputs.UserIdentityPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
