@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IsNullOrUndefined Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'IsNullOrUndefined'.
 */
public data class IsNullOrUndefinedAdvancedFilterResponse(
    public val key: String? = null,
    public val operatorType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.IsNullOrUndefinedAdvancedFilterResponse): IsNullOrUndefinedAdvancedFilterResponse = IsNullOrUndefinedAdvancedFilterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType(),
        )
    }
}
