@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.
 * @property sourceField Name of a field in the input event schema that's to be used as the source of a mapping.
 */
public data class JsonFieldResponse(
    public val sourceField: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.JsonFieldResponse): JsonFieldResponse = JsonFieldResponse(
            sourceField = javaType.sourceField().map({ args0 -> args0 }).orElse(null),
        )
    }
}
