@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This is used to express the source of an input schema mapping for a single target field
 * in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
 * 'eventtype' and 'dataversion' properties. This represents a field in the input event schema
 * along with a default value to be used, and at least one of these two properties should be provided.
 * @property defaultValue The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
 * @property sourceField Name of a field in the input event schema that's to be used as the source of a mapping.
 */
public data class JsonFieldWithDefaultResponse(
    public val defaultValue: String? = null,
    public val sourceField: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.JsonFieldWithDefaultResponse): JsonFieldWithDefaultResponse = JsonFieldWithDefaultResponse(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            sourceField = javaType.sourceField().map({ args0 -> args0 }).orElse(null),
        )
    }
}
