@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Shared access keys of the Domain.
 * @property key1 Shared access key1 for the domain.
 * @property key2 Shared access key2 for the domain.
 */
public data class ListDomainSharedAccessKeysResult(
    public val key1: String? = null,
    public val key2: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ListDomainSharedAccessKeysResult): ListDomainSharedAccessKeysResult = ListDomainSharedAccessKeysResult(
            key1 = javaType.key1().map({ args0 -> args0 }).orElse(null),
            key2 = javaType.key2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
