@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents available Sku pricing tiers.
 * @property capacity Specifies the number of Throughput Units that defines the capacity for the namespace. The property default value is
 * 1 which signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace. Min capacity is 1 and
 * max allowed capacity is 20.
 * @property name The name of the SKU.
 */
public data class NamespaceSkuResponse(
    public val capacity: Int? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.NamespaceSkuResponse): NamespaceSkuResponse = NamespaceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
