@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * NumberLessThan Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberLessThan'.
 * @property value The filter value.
 */
public data class NumberLessThanAdvancedFilterResponse(
    public val key: String? = null,
    public val operatorType: String,
    public val `value`: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.NumberLessThanAdvancedFilterResponse): NumberLessThanAdvancedFilterResponse = NumberLessThanAdvancedFilterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
