@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * The partner authorization details.
 * @property authorizedPartnersList The list of authorized partners.
 * @property defaultMaximumExpirationTimeInDays Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
 * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
 */
public data class PartnerAuthorizationResponse(
    public val authorizedPartnersList: List<PartnerResponse>? = null,
    public val defaultMaximumExpirationTimeInDays: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.PartnerAuthorizationResponse): PartnerAuthorizationResponse = PartnerAuthorizationResponse(
            authorizedPartnersList = javaType.authorizedPartnersList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerResponse.Companion.toKotlin(args0)
                })
            }),
            defaultMaximumExpirationTimeInDays = javaType.defaultMaximumExpirationTimeInDays().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
