@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the partner.
 * @property authorizationExpirationTimeInUtc Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or delete resources in subscriber's
 * context will fail. If specified, the allowed values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
 * If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration or 7 if this value is not specified.
 * @property partnerName The partner name.
 * @property partnerRegistrationImmutableId The immutableId of the corresponding partner registration.
 */
public data class PartnerResponse(
    public val authorizationExpirationTimeInUtc: String? = null,
    public val partnerName: String? = null,
    public val partnerRegistrationImmutableId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.PartnerResponse): PartnerResponse = PartnerResponse(
            authorizationExpirationTimeInUtc = javaType.authorizationExpirationTimeInUtc().map({ args0 ->
                args0
            }).orElse(null),
            partnerName = javaType.partnerName().map({ args0 -> args0 }).orElse(null),
            partnerRegistrationImmutableId = javaType.partnerRegistrationImmutableId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
