@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Information about the retry policy for an event subscription.
 * @property eventTimeToLiveInMinutes Time To Live (in minutes) for events.
 * @property maxDeliveryAttempts Maximum number of delivery retry attempts for events.
 */
public data class RetryPolicyResponse(
    public val eventTimeToLiveInMinutes: Int? = null,
    public val maxDeliveryAttempts: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.RetryPolicyResponse): RetryPolicyResponse = RetryPolicyResponse(
            eventTimeToLiveInMinutes = javaType.eventTimeToLiveInMinutes().map({ args0 -> args0 }).orElse(null),
            maxDeliveryAttempts = javaType.maxDeliveryAttempts().map({ args0 -> args0 }).orElse(null),
        )
    }
}
