@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Routing identity info for topic spaces configuration.
 * @property type
 * @property userAssignedIdentity
 */
public data class RoutingIdentityInfoResponse(
    public val type: String? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.RoutingIdentityInfoResponse): RoutingIdentityInfoResponse = RoutingIdentityInfoResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
