@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about the service bus topic destination for an event subscription.
 * @property deliveryAttributeMappings Delivery attribute details.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'ServiceBusTopic'.
 * @property resourceId The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
 */
public data class ServiceBusTopicEventSubscriptionDestinationResponse(
    public val deliveryAttributeMappings: List<Either<DynamicDeliveryAttributeMappingResponse, StaticDeliveryAttributeMappingResponse>>? =
        null,
    public val endpointType: String,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ServiceBusTopicEventSubscriptionDestinationResponse): ServiceBusTopicEventSubscriptionDestinationResponse =
            ServiceBusTopicEventSubscriptionDestinationResponse(
                deliveryAttributeMappings = javaType.deliveryAttributeMappings().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.eventgrid.kotlin.outputs.DynamicDeliveryAttributeMappingResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.eventgrid.kotlin.outputs.StaticDeliveryAttributeMappingResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                endpointType = javaType.endpointType(),
                resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
