@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * StringContains Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'StringContains'.
 * @property values The set of filter values.
 */
public data class StringContainsAdvancedFilterResponse(
    public val key: String? = null,
    public val operatorType: String,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.StringContainsAdvancedFilterResponse): StringContainsAdvancedFilterResponse = StringContainsAdvancedFilterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
