@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the Topic Spaces Configuration.
 * @property clientAuthentication Client authentication settings for topic spaces configuration.
 * @property hostname The endpoint for the topic spaces configuration. This is a read-only property.
 * @property maximumClientSessionsPerAuthenticationName The maximum number of sessions per authentication name. The property default value is 1.
 * Min allowed value is 1 and max allowed value is 100.
 * @property maximumSessionExpiryInHours The maximum session expiry in hours. The property default value is 1 hour.
 * Min allowed value is 1 hour and max allowed value is 8 hours.
 * @property routeTopicResourceId Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
 * This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
 * This topic should reside in the same region where namespace is located.
 * @property routingEnrichments Routing enrichments for topic spaces configuration
 * @property routingIdentityInfo Routing identity info for topic spaces configuration.
 * @property state Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
 */
public data class TopicSpacesConfigurationResponse(
    public val clientAuthentication: ClientAuthenticationSettingsResponse? = null,
    public val hostname: String,
    public val maximumClientSessionsPerAuthenticationName: Int? = null,
    public val maximumSessionExpiryInHours: Int? = null,
    public val routeTopicResourceId: String? = null,
    public val routingEnrichments: RoutingEnrichmentsResponse? = null,
    public val routingIdentityInfo: RoutingIdentityInfoResponse? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.TopicSpacesConfigurationResponse): TopicSpacesConfigurationResponse = TopicSpacesConfigurationResponse(
            clientAuthentication = javaType.clientAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientAuthenticationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostname = javaType.hostname(),
            maximumClientSessionsPerAuthenticationName = javaType.maximumClientSessionsPerAuthenticationName().map({ args0 ->
                args0
            }).orElse(null),
            maximumSessionExpiryInHours = javaType.maximumSessionExpiryInHours().map({ args0 ->
                args0
            }).orElse(null),
            routeTopicResourceId = javaType.routeTopicResourceId().map({ args0 -> args0 }).orElse(null),
            routingEnrichments = javaType.routingEnrichments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.RoutingEnrichmentsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingIdentityInfo = javaType.routingIdentityInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.RoutingIdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
