@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about the webhook destination for an event subscription.
 * @property azureActiveDirectoryApplicationIdOrUri The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
 * @property azureActiveDirectoryTenantId The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
 * @property deliveryAttributeMappings Delivery attribute details.
 * @property endpointBaseUrl The base URL that represents the endpoint of the destination of an event subscription.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'WebHook'.
 * @property endpointUrl The URL that represents the endpoint of the destination of an event subscription.
 * @property maxEventsPerBatch Maximum number of events per batch.
 * @property preferredBatchSizeInKilobytes Preferred batch size in Kilobytes.
 */
public data class WebHookEventSubscriptionDestinationResponse(
    public val azureActiveDirectoryApplicationIdOrUri: String? = null,
    public val azureActiveDirectoryTenantId: String? = null,
    public val deliveryAttributeMappings: List<Either<DynamicDeliveryAttributeMappingResponse, StaticDeliveryAttributeMappingResponse>>? =
        null,
    public val endpointBaseUrl: String,
    public val endpointType: String,
    public val endpointUrl: String? = null,
    public val maxEventsPerBatch: Int? = null,
    public val preferredBatchSizeInKilobytes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.WebHookEventSubscriptionDestinationResponse): WebHookEventSubscriptionDestinationResponse = WebHookEventSubscriptionDestinationResponse(
            azureActiveDirectoryApplicationIdOrUri = javaType.azureActiveDirectoryApplicationIdOrUri().map({ args0 ->
                args0
            }).orElse(null),
            azureActiveDirectoryTenantId = javaType.azureActiveDirectoryTenantId().map({ args0 ->
                args0
            }).orElse(null),
            deliveryAttributeMappings = javaType.deliveryAttributeMappings().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.eventgrid.kotlin.outputs.DynamicDeliveryAttributeMappingResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.eventgrid.kotlin.outputs.StaticDeliveryAttributeMappingResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            endpointBaseUrl = javaType.endpointBaseUrl(),
            endpointType = javaType.endpointType(),
            endpointUrl = javaType.endpointUrl().map({ args0 -> args0 }).orElse(null),
            maxEventsPerBatch = javaType.maxEventsPerBatch().map({ args0 -> args0 }).orElse(null),
            preferredBatchSizeInKilobytes = javaType.preferredBatchSizeInKilobytes().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
