@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventhub.kotlin.outputs.ThrottlingPolicyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.ThrottlingPolicyResponse.Companion.toKotlin as throttlingPolicyResponseToKotlin

/**
 * Builder for [ApplicationGroup].
 */
@PulumiTagMarker
public class ApplicationGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationGroupArgs = ApplicationGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationGroupArgsBuilder.() -> Unit) {
        val builder = ApplicationGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationGroup {
        val builtJavaResource =
            com.pulumi.azurenative.eventhub.ApplicationGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationGroup(builtJavaResource)
    }
}

/**
 * The Application Group object
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### ApplicationGroupCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationGroup = new AzureNative.EventHub.ApplicationGroup("applicationGroup", new()
 *     {
 *         ApplicationGroupName = "appGroup1",
 *         ClientAppGroupIdentifier = "SASKeyName=KeyName",
 *         IsEnabled = true,
 *         NamespaceName = "contoso-ua-test-eh-system-1",
 *         Policies = new[]
 *         {
 *             new AzureNative.EventHub.Inputs.ThrottlingPolicyArgs
 *             {
 *                 MetricId = AzureNative.EventHub.MetricId.IncomingMessages,
 *                 Name = "ThrottlingPolicy1",
 *                 RateLimitThreshold = 7912,
 *                 Type = "ThrottlingPolicy",
 *             },
 *             new AzureNative.EventHub.Inputs.ThrottlingPolicyArgs
 *             {
 *                 MetricId = AzureNative.EventHub.MetricId.IncomingBytes,
 *                 Name = "ThrottlingPolicy2",
 *                 RateLimitThreshold = 3951729,
 *                 Type = "ThrottlingPolicy",
 *             },
 *             new AzureNative.EventHub.Inputs.ThrottlingPolicyArgs
 *             {
 *                 MetricId = AzureNative.EventHub.MetricId.OutgoingBytes,
 *                 Name = "ThrottlingPolicy3",
 *                 RateLimitThreshold = 245175,
 *                 Type = "ThrottlingPolicy",
 *             },
 *         },
 *         ResourceGroupName = "contosotest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventhub.NewApplicationGroup(ctx, "applicationGroup", &eventhub.ApplicationGroupArgs{
 * ApplicationGroupName: pulumi.String("appGroup1"),
 * ClientAppGroupIdentifier: pulumi.String("SASKeyName=KeyName"),
 * IsEnabled: pulumi.Bool(true),
 * NamespaceName: pulumi.String("contoso-ua-test-eh-system-1"),
 * Policies: eventhub.ThrottlingPolicyArray{
 * interface{}{
 * MetricId: pulumi.String(eventhub.MetricIdIncomingMessages),
 * Name: pulumi.String("ThrottlingPolicy1"),
 * RateLimitThreshold: pulumi.Float64(7912),
 * Type: pulumi.String("ThrottlingPolicy"),
 * },
 * interface{}{
 * MetricId: pulumi.String(eventhub.MetricIdIncomingBytes),
 * Name: pulumi.String("ThrottlingPolicy2"),
 * RateLimitThreshold: pulumi.Float64(3951729),
 * Type: pulumi.String("ThrottlingPolicy"),
 * },
 * interface{}{
 * MetricId: pulumi.String(eventhub.MetricIdOutgoingBytes),
 * Name: pulumi.String("ThrottlingPolicy3"),
 * RateLimitThreshold: pulumi.Float64(245175),
 * Type: pulumi.String("ThrottlingPolicy"),
 * },
 * },
 * ResourceGroupName: pulumi.String("contosotest"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.ApplicationGroup;
 * import com.pulumi.azurenative.eventhub.ApplicationGroupArgs;
 * import com.pulumi.azurenative.eventhub.inputs.ThrottlingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationGroup = new ApplicationGroup("applicationGroup", ApplicationGroupArgs.builder()
 *             .applicationGroupName("appGroup1")
 *             .clientAppGroupIdentifier("SASKeyName=KeyName")
 *             .isEnabled(true)
 *             .namespaceName("contoso-ua-test-eh-system-1")
 *             .policies(
 *                 ThrottlingPolicyArgs.builder()
 *                     .metricId("IncomingMessages")
 *                     .name("ThrottlingPolicy1")
 *                     .rateLimitThreshold(7912)
 *                     .type("ThrottlingPolicy")
 *                     .build(),
 *                 ThrottlingPolicyArgs.builder()
 *                     .metricId("IncomingBytes")
 *                     .name("ThrottlingPolicy2")
 *                     .rateLimitThreshold(3951729)
 *                     .type("ThrottlingPolicy")
 *                     .build(),
 *                 ThrottlingPolicyArgs.builder()
 *                     .metricId("OutgoingBytes")
 *                     .name("ThrottlingPolicy3")
 *                     .rateLimitThreshold(245175)
 *                     .type("ThrottlingPolicy")
 *                     .build())
 *             .resourceGroupName("contosotest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:ApplicationGroup appGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups/{applicationGroupName}
 * ```
 */
public class ApplicationGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.eventhub.ApplicationGroup,
) : KotlinCustomResource(javaResource, ApplicationGroupMapper) {
    /**
     * The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
     */
    public val clientAppGroupIdentifier: Output<String>
        get() = javaResource.clientAppGroupIdentifier().applyValue({ args0 -> args0 })

    /**
     * Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    public val policies: Output<List<ThrottlingPolicyResponse>>?
        get() = javaResource.policies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> throttlingPolicyResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationGroupMapper : ResourceMapper<ApplicationGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventhub.ApplicationGroup::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationGroup = ApplicationGroup(
        javaResource as
            com.pulumi.azurenative.eventhub.ApplicationGroup,
    )
}

/**
 * @see [ApplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationGroup].
 */
public suspend fun applicationGroup(
    name: String,
    block: suspend ApplicationGroupResourceBuilder.() -> Unit,
): ApplicationGroup {
    val builder = ApplicationGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationGroup(name: String): ApplicationGroup {
    val builder = ApplicationGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
