@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConsumerGroup].
 */
@PulumiTagMarker
public class ConsumerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConsumerGroupArgs = ConsumerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConsumerGroupArgsBuilder.() -> Unit) {
        val builder = ConsumerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConsumerGroup {
        val builtJavaResource = com.pulumi.azurenative.eventhub.ConsumerGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConsumerGroup(builtJavaResource)
    }
}

/**
 * Single item in List or Get Consumer group operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### ConsumerGroupCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var consumerGroup = new AzureNative.EventHub.ConsumerGroup("consumerGroup", new()
 *     {
 *         ConsumerGroupName = "sdk-ConsumerGroup-5563",
 *         EventHubName = "sdk-EventHub-6681",
 *         NamespaceName = "sdk-Namespace-2661",
 *         ResourceGroupName = "ArunMonocle",
 *         UserMetadata = "New consumergroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewConsumerGroup(ctx, "consumerGroup", &eventhub.ConsumerGroupArgs{
 * 			ConsumerGroupName: pulumi.String("sdk-ConsumerGroup-5563"),
 * 			EventHubName:      pulumi.String("sdk-EventHub-6681"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-2661"),
 * 			ResourceGroupName: pulumi.String("ArunMonocle"),
 * 			UserMetadata:      pulumi.String("New consumergroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.ConsumerGroup;
 * import com.pulumi.azurenative.eventhub.ConsumerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var consumerGroup = new ConsumerGroup("consumerGroup", ConsumerGroupArgs.builder()
 *             .consumerGroupName("sdk-ConsumerGroup-5563")
 *             .eventHubName("sdk-EventHub-6681")
 *             .namespaceName("sdk-Namespace-2661")
 *             .resourceGroupName("ArunMonocle")
 *             .userMetadata("New consumergroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:ConsumerGroup sdk-ConsumerGroup-5563 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}
 * ```
 */
public class ConsumerGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.eventhub.ConsumerGroup,
) : KotlinCustomResource(javaResource, ConsumerGroupMapper) {
    /**
     * Exact time the message was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The exact time the message was updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
     */
    public val userMetadata: Output<String>?
        get() = javaResource.userMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ConsumerGroupMapper : ResourceMapper<ConsumerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventhub.ConsumerGroup::class == javaResource::class

    override fun map(javaResource: Resource): ConsumerGroup = ConsumerGroup(
        javaResource as
            com.pulumi.azurenative.eventhub.ConsumerGroup,
    )
}

/**
 * @see [ConsumerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConsumerGroup].
 */
public suspend fun consumerGroup(
    name: String,
    block: suspend ConsumerGroupResourceBuilder.() -> Unit,
): ConsumerGroup {
    val builder = ConsumerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConsumerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun consumerGroup(name: String): ConsumerGroup {
    val builder = ConsumerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
