@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.EventHubArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.EntityStatus
import com.pulumi.azurenative.eventhub.kotlin.inputs.CaptureDescriptionArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.CaptureDescriptionArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.RetentionDescriptionArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.RetentionDescriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Single item in List or Get Event Hub operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### EventHubCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHub = new AzureNative.EventHub.EventHub("eventHub", new()
 *     {
 *         CaptureDescription = new AzureNative.EventHub.Inputs.CaptureDescriptionArgs
 *         {
 *             Destination = new AzureNative.EventHub.Inputs.DestinationArgs
 *             {
 *                 ArchiveNameFormat = "{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}",
 *                 BlobContainer = "container",
 *                 Name = "EventHubArchive.AzureBlockBlob",
 *                 StorageAccountResourceId = "/subscriptions/e2f361f0-3b27-4503-a9cc-21cfba380093/resourceGroups/Default-Storage-SouthCentralUS/providers/Microsoft.ClassicStorage/storageAccounts/arjunteststorage",
 *             },
 *             Enabled = true,
 *             Encoding = AzureNative.EventHub.EncodingCaptureDescription.Avro,
 *             IntervalInSeconds = 120,
 *             SizeLimitInBytes = 10485763,
 *         },
 *         EventHubName = "sdk-EventHub-6547",
 *         MessageRetentionInDays = 4,
 *         NamespaceName = "sdk-Namespace-5357",
 *         PartitionCount = 4,
 *         ResourceGroupName = "Default-NotificationHubs-AustraliaEast",
 *         RetentionDescription = new AzureNative.EventHub.Inputs.RetentionDescriptionArgs
 *         {
 *             CleanupPolicy = AzureNative.EventHub.CleanupPolicyRetentionDescription.Compact,
 *             RetentionTimeInHours = 96,
 *             TombstoneRetentionTimeInHours = 1,
 *         },
 *         Status = AzureNative.EventHub.EntityStatus.Active,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewEventHub(ctx, "eventHub", &eventhub.EventHubArgs{
 * 			CaptureDescription: &eventhub.CaptureDescriptionArgs{
 * 				Destination: &eventhub.DestinationArgs{
 * 					ArchiveNameFormat:        pulumi.String("{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}"),
 * 					BlobContainer:            pulumi.String("container"),
 * 					Name:                     pulumi.String("EventHubArchive.AzureBlockBlob"),
 * 					StorageAccountResourceId: pulumi.String("/subscriptions/e2f361f0-3b27-4503-a9cc-21cfba380093/resourceGroups/Default-Storage-SouthCentralUS/providers/Microsoft.ClassicStorage/storageAccounts/arjunteststorage"),
 * 				},
 * 				Enabled:           pulumi.Bool(true),
 * 				Encoding:          eventhub.EncodingCaptureDescriptionAvro,
 * 				IntervalInSeconds: pulumi.Int(120),
 * 				SizeLimitInBytes:  pulumi.Int(10485763),
 * 			},
 * 			EventHubName:           pulumi.String("sdk-EventHub-6547"),
 * 			MessageRetentionInDays: pulumi.Float64(4),
 * 			NamespaceName:          pulumi.String("sdk-Namespace-5357"),
 * 			PartitionCount:         pulumi.Float64(4),
 * 			ResourceGroupName:      pulumi.String("Default-NotificationHubs-AustraliaEast"),
 * 			RetentionDescription: &eventhub.RetentionDescriptionArgs{
 * 				CleanupPolicy:                 pulumi.String(eventhub.CleanupPolicyRetentionDescriptionCompact),
 * 				RetentionTimeInHours:          pulumi.Float64(96),
 * 				TombstoneRetentionTimeInHours: pulumi.Int(1),
 * 			},
 * 			Status: eventhub.EntityStatusActive,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.EventHub;
 * import com.pulumi.azurenative.eventhub.EventHubArgs;
 * import com.pulumi.azurenative.eventhub.inputs.CaptureDescriptionArgs;
 * import com.pulumi.azurenative.eventhub.inputs.DestinationArgs;
 * import com.pulumi.azurenative.eventhub.inputs.RetentionDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHub = new EventHub("eventHub", EventHubArgs.builder()
 *             .captureDescription(CaptureDescriptionArgs.builder()
 *                 .destination(DestinationArgs.builder()
 *                     .archiveNameFormat("{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}")
 *                     .blobContainer("container")
 *                     .name("EventHubArchive.AzureBlockBlob")
 *                     .storageAccountResourceId("/subscriptions/e2f361f0-3b27-4503-a9cc-21cfba380093/resourceGroups/Default-Storage-SouthCentralUS/providers/Microsoft.ClassicStorage/storageAccounts/arjunteststorage")
 *                     .build())
 *                 .enabled(true)
 *                 .encoding("Avro")
 *                 .intervalInSeconds(120)
 *                 .sizeLimitInBytes(10485763)
 *                 .build())
 *             .eventHubName("sdk-EventHub-6547")
 *             .messageRetentionInDays(4)
 *             .namespaceName("sdk-Namespace-5357")
 *             .partitionCount(4)
 *             .resourceGroupName("Default-NotificationHubs-AustraliaEast")
 *             .retentionDescription(RetentionDescriptionArgs.builder()
 *                 .cleanupPolicy("Compact")
 *                 .retentionTimeInHours(96)
 *                 .tombstoneRetentionTimeInHours(1)
 *                 .build())
 *             .status("Active")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:EventHub sdk-EventHub-10 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}
 * ```
 * @property captureDescription Properties of capture description
 * @property eventHubName The Event Hub name
 * @property messageRetentionInDays Number of days to retain the events for this Event Hub, value should be 1 to 7 days
 * @property namespaceName The Namespace name
 * @property partitionCount Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property retentionDescription Event Hub retention settings
 * @property status Enumerates the possible values for the status of the Event Hub.
 */
public data class EventHubArgs(
    public val captureDescription: Output<CaptureDescriptionArgs>? = null,
    public val eventHubName: Output<String>? = null,
    public val messageRetentionInDays: Output<Double>? = null,
    public val namespaceName: Output<String>? = null,
    public val partitionCount: Output<Double>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionDescription: Output<RetentionDescriptionArgs>? = null,
    public val status: Output<EntityStatus>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.EventHubArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.EventHubArgs =
        com.pulumi.azurenative.eventhub.EventHubArgs.builder()
            .captureDescription(
                captureDescription?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .messageRetentionInDays(messageRetentionInDays?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .partitionCount(partitionCount?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionDescription(
                retentionDescription?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventHubArgs].
 */
@PulumiTagMarker
public class EventHubArgsBuilder internal constructor() {
    private var captureDescription: Output<CaptureDescriptionArgs>? = null

    private var eventHubName: Output<String>? = null

    private var messageRetentionInDays: Output<Double>? = null

    private var namespaceName: Output<String>? = null

    private var partitionCount: Output<Double>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionDescription: Output<RetentionDescriptionArgs>? = null

    private var status: Output<EntityStatus>? = null

    /**
     * @param value Properties of capture description
     */
    @JvmName("qnepeddapecqgwwq")
    public suspend fun captureDescription(`value`: Output<CaptureDescriptionArgs>) {
        this.captureDescription = value
    }

    /**
     * @param value The Event Hub name
     */
    @JvmName("jsfyamufpnjyrxwa")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value Number of days to retain the events for this Event Hub, value should be 1 to 7 days
     */
    @JvmName("amhhfdstusflpjaf")
    public suspend fun messageRetentionInDays(`value`: Output<Double>) {
        this.messageRetentionInDays = value
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("cdkstyrpfcjbyysm")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
     */
    @JvmName("rehklaxepkbnrgpc")
    public suspend fun partitionCount(`value`: Output<Double>) {
        this.partitionCount = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("yfkhppharfhoxcam")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Event Hub retention settings
     */
    @JvmName("yvuxiddppqrlgamk")
    public suspend fun retentionDescription(`value`: Output<RetentionDescriptionArgs>) {
        this.retentionDescription = value
    }

    /**
     * @param value Enumerates the possible values for the status of the Event Hub.
     */
    @JvmName("mhsttkwiowrdnwpx")
    public suspend fun status(`value`: Output<EntityStatus>) {
        this.status = value
    }

    /**
     * @param value Properties of capture description
     */
    @JvmName("udmnobbhkwwqyywb")
    public suspend fun captureDescription(`value`: CaptureDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captureDescription = mapped
    }

    /**
     * @param argument Properties of capture description
     */
    @JvmName("uemuewmrdblqydkt")
    public suspend fun captureDescription(argument: suspend CaptureDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = CaptureDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.captureDescription = mapped
    }

    /**
     * @param value The Event Hub name
     */
    @JvmName("jlajdaabjvbbsbww")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value Number of days to retain the events for this Event Hub, value should be 1 to 7 days
     */
    @JvmName("fqrsutlecfeokwpy")
    public suspend fun messageRetentionInDays(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageRetentionInDays = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("hxajegwjhsihkvus")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
     */
    @JvmName("geoqmrjtykrkddhs")
    public suspend fun partitionCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionCount = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("earrjuuaebbwvwth")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Event Hub retention settings
     */
    @JvmName("qklnvxsivaqbxddl")
    public suspend fun retentionDescription(`value`: RetentionDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDescription = mapped
    }

    /**
     * @param argument Event Hub retention settings
     */
    @JvmName("wuvtbkxqbcrjlqvy")
    public suspend fun retentionDescription(argument: suspend RetentionDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionDescription = mapped
    }

    /**
     * @param value Enumerates the possible values for the status of the Event Hub.
     */
    @JvmName("sxvsrryogfrbniol")
    public suspend fun status(`value`: EntityStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EventHubArgs = EventHubArgs(
        captureDescription = captureDescription,
        eventHubName = eventHubName,
        messageRetentionInDays = messageRetentionInDays,
        namespaceName = namespaceName,
        partitionCount = partitionCount,
        resourceGroupName = resourceGroupName,
        retentionDescription = retentionDescription,
        status = status,
    )
}
