@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.DefaultAction
import com.pulumi.azurenative.eventhub.kotlin.enums.PublicNetworkAccessFlag
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetIpRulesArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetIpRulesArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetVirtualNetworkRulesArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetVirtualNetworkRulesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of topic resource.
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2023-01-01-preview, 2024-01-01, 2024-05-01-preview.
 * ## Example Usage
 * ### NameSpaceNetworkRuleSetCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceNetworkRuleSet = new AzureNative.EventHub.NamespaceNetworkRuleSet("namespaceNetworkRuleSet", new()
 *     {
 *         DefaultAction = AzureNative.EventHub.DefaultAction.Deny,
 *         IpRules = new[]
 *         {
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.EventHub.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.1",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.EventHub.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.2",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.EventHub.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.3",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.EventHub.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.4",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.EventHub.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.5",
 *             },
 *         },
 *         NamespaceName = "sdk-Namespace-6019",
 *         ResourceGroupName = "ResourceGroup",
 *         VirtualNetworkRules = new[]
 *         {
 *             new AzureNative.EventHub.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = true,
 *                 Subnet = new AzureNative.EventHub.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2",
 *                 },
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = false,
 *                 Subnet = new AzureNative.EventHub.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3",
 *                 },
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = false,
 *                 Subnet = new AzureNative.EventHub.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewNamespaceNetworkRuleSet(ctx, "namespaceNetworkRuleSet", &eventhub.NamespaceNetworkRuleSetArgs{
 * 			DefaultAction: pulumi.String(eventhub.DefaultActionDeny),
 * 			IpRules: eventhub.NWRuleSetIpRulesArray{
 * 				&eventhub.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(eventhub.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.1"),
 * 				},
 * 				&eventhub.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(eventhub.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.2"),
 * 				},
 * 				&eventhub.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(eventhub.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.3"),
 * 				},
 * 				&eventhub.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(eventhub.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.4"),
 * 				},
 * 				&eventhub.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(eventhub.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.5"),
 * 				},
 * 			},
 * 			NamespaceName:     pulumi.String("sdk-Namespace-6019"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 			VirtualNetworkRules: eventhub.NWRuleSetVirtualNetworkRulesArray{
 * 				&eventhub.NWRuleSetVirtualNetworkRulesArgs{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(true),
 * 					Subnet: &eventhub.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
 * 					},
 * 				},
 * 				&eventhub.NWRuleSetVirtualNetworkRulesArgs{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 					Subnet: &eventhub.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
 * 					},
 * 				},
 * 				&eventhub.NWRuleSetVirtualNetworkRulesArgs{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 					Subnet: &eventhub.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSet;
 * import com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs;
 * import com.pulumi.azurenative.eventhub.inputs.NWRuleSetIpRulesArgs;
 * import com.pulumi.azurenative.eventhub.inputs.NWRuleSetVirtualNetworkRulesArgs;
 * import com.pulumi.azurenative.eventhub.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceNetworkRuleSet = new NamespaceNetworkRuleSet("namespaceNetworkRuleSet", NamespaceNetworkRuleSetArgs.builder()
 *             .defaultAction("Deny")
 *             .ipRules(
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.1")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.2")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.3")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.4")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.5")
 *                     .build())
 *             .namespaceName("sdk-Namespace-6019")
 *             .resourceGroupName("ResourceGroup")
 *             .virtualNetworkRules(
 *                 NWRuleSetVirtualNetworkRulesArgs.builder()
 *                     .ignoreMissingVnetServiceEndpoint(true)
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2")
 *                         .build())
 *                     .build(),
 *                 NWRuleSetVirtualNetworkRulesArgs.builder()
 *                     .ignoreMissingVnetServiceEndpoint(false)
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3")
 *                         .build())
 *                     .build(),
 *                 NWRuleSetVirtualNetworkRulesArgs.builder()
 *                     .ignoreMissingVnetServiceEndpoint(false)
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:NamespaceNetworkRuleSet default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/networkRuleSets/default
 * ```
 * @property defaultAction Default Action for Network Rule Set
 * @property ipRules List of IpRules
 * @property namespaceName The Namespace name
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property trustedServiceAccessEnabled Value that indicates whether Trusted Service Access is Enabled or not.
 * @property virtualNetworkRules List VirtualNetwork Rules
 */
public data class NamespaceNetworkRuleSetArgs(
    public val defaultAction: Output<Either<String, DefaultAction>>? = null,
    public val ipRules: Output<List<NWRuleSetIpRulesArgs>>? = null,
    public val namespaceName: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessFlag>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val trustedServiceAccessEnabled: Output<Boolean>? = null,
    public val virtualNetworkRules: Output<List<NWRuleSetVirtualNetworkRulesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs =
        com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs.builder()
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .trustedServiceAccessEnabled(trustedServiceAccessEnabled?.applyValue({ args0 -> args0 }))
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NamespaceNetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NamespaceNetworkRuleSetArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, DefaultAction>>? = null

    private var ipRules: Output<List<NWRuleSetIpRulesArgs>>? = null

    private var namespaceName: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessFlag>>? = null

    private var resourceGroupName: Output<String>? = null

    private var trustedServiceAccessEnabled: Output<Boolean>? = null

    private var virtualNetworkRules: Output<List<NWRuleSetVirtualNetworkRulesArgs>>? = null

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("qpjykkccmygoavlp")
    public suspend fun defaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value List of IpRules
     */
    @JvmName("gxrpycfchkvybxrs")
    public suspend fun ipRules(`value`: Output<List<NWRuleSetIpRulesArgs>>) {
        this.ipRules = value
    }

    @JvmName("ieseellkgcyonmfs")
    public suspend fun ipRules(vararg values: Output<NWRuleSetIpRulesArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values List of IpRules
     */
    @JvmName("tknbrvotcmdyomhp")
    public suspend fun ipRules(values: List<Output<NWRuleSetIpRulesArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("sgrxljaiufamikrd")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("xgptranidxyinjps")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessFlag>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("olesndglreplbayj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Value that indicates whether Trusted Service Access is Enabled or not.
     */
    @JvmName("rttuimrlplsojggj")
    public suspend fun trustedServiceAccessEnabled(`value`: Output<Boolean>) {
        this.trustedServiceAccessEnabled = value
    }

    /**
     * @param value List VirtualNetwork Rules
     */
    @JvmName("fvohcsuvbxowkunc")
    public suspend fun virtualNetworkRules(`value`: Output<List<NWRuleSetVirtualNetworkRulesArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("jrsdinwgndmptmqu")
    public suspend fun virtualNetworkRules(vararg values: Output<NWRuleSetVirtualNetworkRulesArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values List VirtualNetwork Rules
     */
    @JvmName("lpketonrjnduxfbx")
    public suspend fun virtualNetworkRules(values: List<Output<NWRuleSetVirtualNetworkRulesArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("hcggtymmebhpgiun")
    public suspend fun defaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("wabgfbqiadjjqsfa")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("aswmnjfvjbysdnyi")
    public fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value List of IpRules
     */
    @JvmName("xsewhurmdmvpngqi")
    public suspend fun ipRules(`value`: List<NWRuleSetIpRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules
     */
    @JvmName("jxewwmqhylptpjmj")
    public suspend fun ipRules(argument: List<suspend NWRuleSetIpRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NWRuleSetIpRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules
     */
    @JvmName("pfcogtaxrwpctrbr")
    public suspend fun ipRules(vararg argument: suspend NWRuleSetIpRulesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NWRuleSetIpRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules
     */
    @JvmName("kskinsibpbhpactp")
    public suspend fun ipRules(argument: suspend NWRuleSetIpRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NWRuleSetIpRulesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values List of IpRules
     */
    @JvmName("ycnrfncqnavmrhqs")
    public suspend fun ipRules(vararg values: NWRuleSetIpRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("gxcytutcyqqjpobe")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("tycuwarcpwbeegdm")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessFlag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("jfmpybecbgfsquhl")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("yyvnxjahlyvakswl")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessFlag) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("oioidxoiidwfoktb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Value that indicates whether Trusted Service Access is Enabled or not.
     */
    @JvmName("hjjgeuukmewgoiuv")
    public suspend fun trustedServiceAccessEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedServiceAccessEnabled = mapped
    }

    /**
     * @param value List VirtualNetwork Rules
     */
    @JvmName("sjorabiuumjhdwte")
    public suspend fun virtualNetworkRules(`value`: List<NWRuleSetVirtualNetworkRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List VirtualNetwork Rules
     */
    @JvmName("vunvehboopuhghbt")
    public suspend fun virtualNetworkRules(argument: List<suspend NWRuleSetVirtualNetworkRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NWRuleSetVirtualNetworkRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List VirtualNetwork Rules
     */
    @JvmName("nctmflqlfjmrjfwy")
    public suspend fun virtualNetworkRules(vararg argument: suspend NWRuleSetVirtualNetworkRulesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NWRuleSetVirtualNetworkRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List VirtualNetwork Rules
     */
    @JvmName("tkhquipfkmgfvlyc")
    public suspend fun virtualNetworkRules(argument: suspend NWRuleSetVirtualNetworkRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NWRuleSetVirtualNetworkRulesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values List VirtualNetwork Rules
     */
    @JvmName("mibpfhimoyhnfais")
    public suspend fun virtualNetworkRules(vararg values: NWRuleSetVirtualNetworkRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): NamespaceNetworkRuleSetArgs = NamespaceNetworkRuleSetArgs(
        defaultAction = defaultAction,
        ipRules = ipRules,
        namespaceName = namespaceName,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        trustedServiceAccessEnabled = trustedServiceAccessEnabled,
        virtualNetworkRules = virtualNetworkRules,
    )
}
