@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the Private Endpoint Connection.
 */
public enum class EndPointProvisioningState(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState> {
    Creating(com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState.Creating),
    Updating(com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState.Deleting),
    Succeeded(com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState.Succeeded),
    Canceled(com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState.Canceled),
    Failed(com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.EndPointProvisioningState): EndPointProvisioningState =
            EndPointProvisioningState.values().first { it.javaValue == javaType }
    }
}
