@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enumerates the possible values for the status of the Event Hub.
 */
public enum class EntityStatus(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.EntityStatus,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.EntityStatus> {
    Active(com.pulumi.azurenative.eventhub.enums.EntityStatus.Active),
    Disabled(com.pulumi.azurenative.eventhub.enums.EntityStatus.Disabled),
    Restoring(com.pulumi.azurenative.eventhub.enums.EntityStatus.Restoring),
    SendDisabled(com.pulumi.azurenative.eventhub.enums.EntityStatus.SendDisabled),
    ReceiveDisabled(com.pulumi.azurenative.eventhub.enums.EntityStatus.ReceiveDisabled),
    Creating(com.pulumi.azurenative.eventhub.enums.EntityStatus.Creating),
    Deleting(com.pulumi.azurenative.eventhub.enums.EntityStatus.Deleting),
    Renaming(com.pulumi.azurenative.eventhub.enums.EntityStatus.Renaming),
    Unknown(com.pulumi.azurenative.eventhub.enums.EntityStatus.Unknown),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.EntityStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.EntityStatus): EntityStatus = EntityStatus.values().first { it.javaValue == javaType }
    }
}
