@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if traffic is allowed over public network. By default it is enabled.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess.Disabled),
    SecuredByPerimeter(com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess.SecuredByPerimeter),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
