@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Capture storage details for capture description
 * @property archiveNameFormat Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
 * @property blobContainer Blob container Name
 * @property dataLakeAccountName The Azure Data Lake Store name for the captured events
 * @property dataLakeFolderPath The destination folder path for the captured events
 * @property dataLakeSubscriptionId Subscription Id of Azure Data Lake Store
 * @property name Name for capture destination
 * @property storageAccountResourceId Resource id of the storage account to be used to create the blobs
 */
public data class DestinationArgs(
    public val archiveNameFormat: Output<String>? = null,
    public val blobContainer: Output<String>? = null,
    public val dataLakeAccountName: Output<String>? = null,
    public val dataLakeFolderPath: Output<String>? = null,
    public val dataLakeSubscriptionId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.DestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.DestinationArgs =
        com.pulumi.azurenative.eventhub.inputs.DestinationArgs.builder()
            .archiveNameFormat(archiveNameFormat?.applyValue({ args0 -> args0 }))
            .blobContainer(blobContainer?.applyValue({ args0 -> args0 }))
            .dataLakeAccountName(dataLakeAccountName?.applyValue({ args0 -> args0 }))
            .dataLakeFolderPath(dataLakeFolderPath?.applyValue({ args0 -> args0 }))
            .dataLakeSubscriptionId(dataLakeSubscriptionId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DestinationArgs].
 */
@PulumiTagMarker
public class DestinationArgsBuilder internal constructor() {
    private var archiveNameFormat: Output<String>? = null

    private var blobContainer: Output<String>? = null

    private var dataLakeAccountName: Output<String>? = null

    private var dataLakeFolderPath: Output<String>? = null

    private var dataLakeSubscriptionId: Output<String>? = null

    private var name: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    /**
     * @param value Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
     */
    @JvmName("anqqrfvjejwnnqpu")
    public suspend fun archiveNameFormat(`value`: Output<String>) {
        this.archiveNameFormat = value
    }

    /**
     * @param value Blob container Name
     */
    @JvmName("dvuqbxpkmylghhbh")
    public suspend fun blobContainer(`value`: Output<String>) {
        this.blobContainer = value
    }

    /**
     * @param value The Azure Data Lake Store name for the captured events
     */
    @JvmName("ulxdxqmqcgkhtskf")
    public suspend fun dataLakeAccountName(`value`: Output<String>) {
        this.dataLakeAccountName = value
    }

    /**
     * @param value The destination folder path for the captured events
     */
    @JvmName("yldwqwhusvurxegk")
    public suspend fun dataLakeFolderPath(`value`: Output<String>) {
        this.dataLakeFolderPath = value
    }

    /**
     * @param value Subscription Id of Azure Data Lake Store
     */
    @JvmName("lhoymtevgwdwqemi")
    public suspend fun dataLakeSubscriptionId(`value`: Output<String>) {
        this.dataLakeSubscriptionId = value
    }

    /**
     * @param value Name for capture destination
     */
    @JvmName("cwfpiagvntdnrwak")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource id of the storage account to be used to create the blobs
     */
    @JvmName("lgriwfdrlhqkeybr")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
     */
    @JvmName("unuvmoywsarifpkj")
    public suspend fun archiveNameFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveNameFormat = mapped
    }

    /**
     * @param value Blob container Name
     */
    @JvmName("gjimqgubpljbyvju")
    public suspend fun blobContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobContainer = mapped
    }

    /**
     * @param value The Azure Data Lake Store name for the captured events
     */
    @JvmName("gxlgqfbsxqyjqtsq")
    public suspend fun dataLakeAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeAccountName = mapped
    }

    /**
     * @param value The destination folder path for the captured events
     */
    @JvmName("bypnmlkmjbwaqpsd")
    public suspend fun dataLakeFolderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeFolderPath = mapped
    }

    /**
     * @param value Subscription Id of Azure Data Lake Store
     */
    @JvmName("tdwmetbylfdcmfcw")
    public suspend fun dataLakeSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeSubscriptionId = mapped
    }

    /**
     * @param value Name for capture destination
     */
    @JvmName("lxihvrnxmrpfwtqu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource id of the storage account to be used to create the blobs
     */
    @JvmName("sgutcanshoxpmnea")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    internal fun build(): DestinationArgs = DestinationArgs(
        archiveNameFormat = archiveNameFormat,
        blobContainer = blobContainer,
        dataLakeAccountName = dataLakeAccountName,
        dataLakeFolderPath = dataLakeFolderPath,
        dataLakeSubscriptionId = dataLakeSubscriptionId,
        name = name,
        storageAccountResourceId = storageAccountResourceId,
    )
}
