@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.GetSchemaRegistryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property schemaGroupName The Schema Group name
 */
public data class GetSchemaRegistryPlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val schemaGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.GetSchemaRegistryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.GetSchemaRegistryPlainArgs =
        com.pulumi.azurenative.eventhub.inputs.GetSchemaRegistryPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaGroupName(schemaGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSchemaRegistryPlainArgs].
 */
@PulumiTagMarker
public class GetSchemaRegistryPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var schemaGroupName: String? = null

    /**
     * @param value The Namespace name
     */
    @JvmName("fwadsqdoofwfhbhb")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("gmjsygvitujuojvb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Schema Group name
     */
    @JvmName("fwxbwhicdchinwkl")
    public suspend fun schemaGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaGroupName = mapped
    }

    internal fun build(): GetSchemaRegistryPlainArgs = GetSchemaRegistryPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaGroupName = schemaGroupName ?: throw PulumiNullFieldException("schemaGroupName"),
    )
}
