@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.NWRuleSetIpRulesArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.NetworkRuleIPAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The response from the List namespace operation.
 * @property action The IP Filter Action
 * @property ipMask IP Mask
 */
public data class NWRuleSetIpRulesArgs(
    public val action: Output<Either<String, NetworkRuleIPAction>>? = null,
    public val ipMask: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.NWRuleSetIpRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.NWRuleSetIpRulesArgs =
        com.pulumi.azurenative.eventhub.inputs.NWRuleSetIpRulesArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipMask(ipMask?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NWRuleSetIpRulesArgs].
 */
@PulumiTagMarker
public class NWRuleSetIpRulesArgsBuilder internal constructor() {
    private var action: Output<Either<String, NetworkRuleIPAction>>? = null

    private var ipMask: Output<String>? = null

    /**
     * @param value The IP Filter Action
     */
    @JvmName("prxnwopfkrvpholb")
    public suspend fun action(`value`: Output<Either<String, NetworkRuleIPAction>>) {
        this.action = value
    }

    /**
     * @param value IP Mask
     */
    @JvmName("qjjagamtedkqlred")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value The IP Filter Action
     */
    @JvmName("ltadsligbylkmlcu")
    public suspend fun action(`value`: Either<String, NetworkRuleIPAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The IP Filter Action
     */
    @JvmName("hhvarstgemkadrfg")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleIPAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The IP Filter Action
     */
    @JvmName("jkrewhbpfxxqdhuy")
    public fun action(`value`: NetworkRuleIPAction) {
        val toBeMapped = Either.ofRight<String, NetworkRuleIPAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP Mask
     */
    @JvmName("qejhpyurlpxsmdku")
    public suspend fun ipMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    internal fun build(): NWRuleSetIpRulesArgs = NWRuleSetIpRulesArgs(
        action = action,
        ipMask = ipMask,
    )
}
