@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.SkuArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.SkuName
import com.pulumi.azurenative.eventhub.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU parameters supplied to the create namespace operation
 * @property capacity The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
 * @property name Name of this SKU.
 * @property tier The billing tier of this particular SKU.
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, SkuName>>,
    public val tier: Output<Either<String, SkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.SkuArgs =
        com.pulumi.azurenative.eventhub.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, SkuName>>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
     */
    @JvmName("qbrmgpxedkhokitn")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("urnsbffowffdxljg")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("pqupkmjadwghufpo")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
     */
    @JvmName("dbnkharmadjxvokl")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("vchiomaselpepxpa")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("shkkdfgpmvbkukmg")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("qrgxwxfpapymsart")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("hijbymhsfnbkvskp")
    public suspend fun tier(`value`: Either<String, SkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("fifmrebhhvqygrwx")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("yipkloyapspewceo")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
