@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.ThrottlingPolicyArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.MetricId
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the throttling policy
 * @property metricId Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
 * @property name The Name of this policy
 * @property rateLimitThreshold The Threshold limit above which the application group will be throttled.Rate limit is always per second.
 * @property type Application Group Policy types
 * Expected value is 'ThrottlingPolicy'.
 */
public data class ThrottlingPolicyArgs(
    public val metricId: Output<Either<String, MetricId>>,
    public val name: Output<String>,
    public val rateLimitThreshold: Output<Double>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.ThrottlingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.ThrottlingPolicyArgs =
        com.pulumi.azurenative.eventhub.inputs.ThrottlingPolicyArgs.builder()
            .metricId(
                metricId.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .rateLimitThreshold(rateLimitThreshold.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThrottlingPolicyArgs].
 */
@PulumiTagMarker
public class ThrottlingPolicyArgsBuilder internal constructor() {
    private var metricId: Output<Either<String, MetricId>>? = null

    private var name: Output<String>? = null

    private var rateLimitThreshold: Output<Double>? = null

    private var type: Output<String>? = null

    /**
     * @param value Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
     */
    @JvmName("dhqjsqmessdqroul")
    public suspend fun metricId(`value`: Output<Either<String, MetricId>>) {
        this.metricId = value
    }

    /**
     * @param value The Name of this policy
     */
    @JvmName("srajpgtpysgwixwt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Threshold limit above which the application group will be throttled.Rate limit is always per second.
     */
    @JvmName("deimqitpxwyqbceg")
    public suspend fun rateLimitThreshold(`value`: Output<Double>) {
        this.rateLimitThreshold = value
    }

    /**
     * @param value Application Group Policy types
     * Expected value is 'ThrottlingPolicy'.
     */
    @JvmName("otphrtkfrjfgdtah")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
     */
    @JvmName("suxskvrxvcqkcnmw")
    public suspend fun metricId(`value`: Either<String, MetricId>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricId = mapped
    }

    /**
     * @param value Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
     */
    @JvmName("vmedonahbvwpxvpp")
    public fun metricId(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MetricId>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricId = mapped
    }

    /**
     * @param value Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal
     */
    @JvmName("lfssmkcllyobyfgb")
    public fun metricId(`value`: MetricId) {
        val toBeMapped = Either.ofRight<String, MetricId>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricId = mapped
    }

    /**
     * @param value The Name of this policy
     */
    @JvmName("rltatxwhsmiynbvc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Threshold limit above which the application group will be throttled.Rate limit is always per second.
     */
    @JvmName("gqafimjanibtdgqr")
    public suspend fun rateLimitThreshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateLimitThreshold = mapped
    }

    /**
     * @param value Application Group Policy types
     * Expected value is 'ThrottlingPolicy'.
     */
    @JvmName("dvoconmwxvwrqkal")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ThrottlingPolicyArgs = ThrottlingPolicyArgs(
        metricId = metricId ?: throw PulumiNullFieldException("metricId"),
        name = name ?: throw PulumiNullFieldException("name"),
        rateLimitThreshold = rateLimitThreshold ?: throw PulumiNullFieldException("rateLimitThreshold"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
