@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU parameters particular to a cluster instance.
 * @property capacity The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
 * @property name Name of this SKU.
 */
public data class ClusterSkuResponse(
    public val capacity: Int? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.ClusterSkuResponse): ClusterSkuResponse = ClusterSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
