@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Capture storage details for capture description
 * @property archiveNameFormat Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
 * @property blobContainer Blob container Name
 * @property dataLakeAccountName The Azure Data Lake Store name for the captured events
 * @property dataLakeFolderPath The destination folder path for the captured events
 * @property dataLakeSubscriptionId Subscription Id of Azure Data Lake Store
 * @property name Name for capture destination
 * @property storageAccountResourceId Resource id of the storage account to be used to create the blobs
 */
public data class DestinationResponse(
    public val archiveNameFormat: String? = null,
    public val blobContainer: String? = null,
    public val dataLakeAccountName: String? = null,
    public val dataLakeFolderPath: String? = null,
    public val dataLakeSubscriptionId: String? = null,
    public val name: String? = null,
    public val storageAccountResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.DestinationResponse): DestinationResponse = DestinationResponse(
            archiveNameFormat = javaType.archiveNameFormat().map({ args0 -> args0 }).orElse(null),
            blobContainer = javaType.blobContainer().map({ args0 -> args0 }).orElse(null),
            dataLakeAccountName = javaType.dataLakeAccountName().map({ args0 -> args0 }).orElse(null),
            dataLakeFolderPath = javaType.dataLakeFolderPath().map({ args0 -> args0 }).orElse(null),
            dataLakeSubscriptionId = javaType.dataLakeSubscriptionId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            storageAccountResourceId = javaType.storageAccountResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
