@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Application Group object
 * @property clientAppGroupIdentifier The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isEnabled Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property policies List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 */
public data class GetApplicationGroupResult(
    public val clientAppGroupIdentifier: String,
    public val id: String,
    public val isEnabled: Boolean? = null,
    public val location: String,
    public val name: String,
    public val policies: List<ThrottlingPolicyResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetApplicationGroupResult): GetApplicationGroupResult = GetApplicationGroupResult(
            clientAppGroupIdentifier = javaType.clientAppGroupIdentifier(),
            id = javaType.id(),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.ThrottlingPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
