@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Single Event Hubs Cluster resource in List or Get operations.
 * @property createdAt The UTC time when the Event Hubs Cluster was created.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Resource location.
 * @property metricId The metric ID of the cluster resource. Provided by the service and not modifiable by the user.
 * @property name The name of the resource
 * @property sku Properties of the cluster SKU.
 * @property status Status of the Cluster resource
 * @property supportsScaling A value that indicates whether Scaling is Supported.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedAt The UTC time when the Event Hubs Cluster was last updated.
 */
public data class GetClusterResult(
    public val createdAt: String,
    public val id: String,
    public val location: String? = null,
    public val metricId: String,
    public val name: String,
    public val sku: ClusterSkuResponse? = null,
    public val status: String,
    public val supportsScaling: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetClusterResult): GetClusterResult = GetClusterResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metricId = javaType.metricId(),
            name = javaType.name(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.ClusterSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            supportsScaling = javaType.supportsScaling().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
