@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Single item in List or Get Alias(Disaster Recovery configuration) operation
 * @property alternateName Alternate name specified when alias and namespace names are same.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property partnerNamespace ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
 * @property pendingReplicationOperationsCount Number of entities pending to be replicated.
 * @property provisioningState Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded' or 'Failed'
 * @property role role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 */
public data class GetDisasterRecoveryConfigResult(
    public val alternateName: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val partnerNamespace: String? = null,
    public val pendingReplicationOperationsCount: Double,
    public val provisioningState: String,
    public val role: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetDisasterRecoveryConfigResult): GetDisasterRecoveryConfigResult = GetDisasterRecoveryConfigResult(
            alternateName = javaType.alternateName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            partnerNamespace = javaType.partnerNamespace().map({ args0 -> args0 }).orElse(null),
            pendingReplicationOperationsCount = javaType.pendingReplicationOperationsCount(),
            provisioningState = javaType.provisioningState(),
            role = javaType.role(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
