@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Single item in List or Get Event Hub operation
 * @property captureDescription Properties of capture description
 * @property createdAt Exact time the Event Hub was created.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property messageRetentionInDays Number of days to retain the events for this Event Hub, value should be 1 to 7 days
 * @property name The name of the resource
 * @property partitionCount Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
 * @property partitionIds Current number of shards on the Event Hub.
 * @property retentionDescription Event Hub retention settings
 * @property status Enumerates the possible values for the status of the Event Hub.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAt The exact time the message was updated.
 */
public data class GetEventHubResult(
    public val captureDescription: CaptureDescriptionResponse? = null,
    public val createdAt: String,
    public val id: String,
    public val location: String,
    public val messageRetentionInDays: Double? = null,
    public val name: String,
    public val partitionCount: Double? = null,
    public val partitionIds: List<String>,
    public val retentionDescription: RetentionDescriptionResponse? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetEventHubResult): GetEventHubResult = GetEventHubResult(
            captureDescription = javaType.captureDescription().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.CaptureDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            location = javaType.location(),
            messageRetentionInDays = javaType.messageRetentionInDays().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partitionCount = javaType.partitionCount().map({ args0 -> args0 }).orElse(null),
            partitionIds = javaType.partitionIds().map({ args0 -> args0 }),
            retentionDescription = javaType.retentionDescription().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.RetentionDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
