@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Single Namespace item in List or Get Operation
 * @property alternateName Alternate name specified when alias and namespace names are same.
 * @property clusterArmId Cluster ARM ID of the Namespace.
 * @property createdAt The time the Namespace was created.
 * @property disableLocalAuth This property disables SAS authentication for the Event Hubs namespace.
 * @property encryption Properties of BYOK Encryption description
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Properties of BYOK Identity description
 * @property isAutoInflateEnabled Value that indicates whether AutoInflate is enabled for eventhub namespace.
 * @property kafkaEnabled Value that indicates whether Kafka is enabled for eventhub namespace.
 * @property location Resource location.
 * @property maximumThroughputUnits Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true)
 * @property metricId Identifier for Azure Insights metrics.
 * @property minimumTlsVersion The minimum TLS version for the cluster to support, e.g. '1.2'
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connections.
 * @property provisioningState Provisioning state of the Namespace.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * @property serviceBusEndpoint Endpoint you can use to perform Service Bus operations.
 * @property sku Properties of sku resource
 * @property status Status of the Namespace.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedAt The time the Namespace was updated.
 * @property zoneRedundant Enabling this property creates a Standard Event Hubs Namespace in regions supported availability zones.
 */
public data class GetNamespaceResult(
    public val alternateName: String? = null,
    public val clusterArmId: String? = null,
    public val createdAt: String,
    public val disableLocalAuth: Boolean? = null,
    public val encryption: EncryptionResponse? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val isAutoInflateEnabled: Boolean? = null,
    public val kafkaEnabled: Boolean? = null,
    public val location: String? = null,
    public val maximumThroughputUnits: Int? = null,
    public val metricId: String,
    public val minimumTlsVersion: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val serviceBusEndpoint: String,
    public val sku: SkuResponse? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val updatedAt: String,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetNamespaceResult): GetNamespaceResult = GetNamespaceResult(
            alternateName = javaType.alternateName().map({ args0 -> args0 }).orElse(null),
            clusterArmId = javaType.clusterArmId().map({ args0 -> args0 }).orElse(null),
            createdAt = javaType.createdAt(),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isAutoInflateEnabled = javaType.isAutoInflateEnabled().map({ args0 -> args0 }).orElse(null),
            kafkaEnabled = javaType.kafkaEnabled().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maximumThroughputUnits = javaType.maximumThroughputUnits().map({ args0 -> args0 }).orElse(null),
            metricId = javaType.metricId(),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceBusEndpoint = javaType.serviceBusEndpoint(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
