@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Single item in a List or Get VirtualNetworkRules operation
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualNetworkSubnetId ARM ID of Virtual Network Subnet
 */
public data class GetNamespaceVirtualNetworkRuleResult(
    public val id: String,
    public val name: String,
    public val type: String,
    public val virtualNetworkSubnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetNamespaceVirtualNetworkRuleResult): GetNamespaceVirtualNetworkRuleResult = GetNamespaceVirtualNetworkRuleResult(
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
            virtualNetworkSubnetId = javaType.virtualNetworkSubnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
