@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Single item in List or Get Schema Group operation
 * @property createdAtUtc Exact time the Schema Group was created.
 * @property eTag The ETag value.
 * @property groupProperties dictionary object for SchemaGroup group properties
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property schemaCompatibility
 * @property schemaType
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAtUtc Exact time the Schema Group was updated
 */
public data class GetSchemaRegistryResult(
    public val createdAtUtc: String,
    public val eTag: String,
    public val groupProperties: Map<String, String>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val schemaCompatibility: String? = null,
    public val schemaType: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAtUtc: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetSchemaRegistryResult): GetSchemaRegistryResult = GetSchemaRegistryResult(
            createdAtUtc = javaType.createdAtUtc(),
            eTag = javaType.eTag(),
            groupProperties = javaType.groupProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            schemaCompatibility = javaType.schemaCompatibility().map({ args0 -> args0 }).orElse(null),
            schemaType = javaType.schemaType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAtUtc = javaType.updatedAtUtc(),
        )
    }
}
