@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties to configure keyVault Properties
 * @property identity
 * @property keyName Name of the Key from KeyVault
 * @property keyVaultUri Uri of KeyVault
 * @property keyVersion Key Version
 */
public data class KeyVaultPropertiesResponse(
    public val identity: UserAssignedIdentityPropertiesResponse? = null,
    public val keyName: String? = null,
    public val keyVaultUri: String? = null,
    public val keyVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.UserAssignedIdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
