@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Namespace/EventHub Connection String
 * @property aliasPrimaryConnectionString Primary connection string of the alias if GEO DR is enabled
 * @property aliasSecondaryConnectionString Secondary  connection string of the alias if GEO DR is enabled
 * @property keyName A string that describes the AuthorizationRule.
 * @property primaryConnectionString Primary connection string of the created namespace AuthorizationRule.
 * @property primaryKey A base64-encoded 256-bit primary key for signing and validating the SAS token.
 * @property secondaryConnectionString Secondary connection string of the created namespace AuthorizationRule.
 * @property secondaryKey A base64-encoded 256-bit primary key for signing and validating the SAS token.
 */
public data class ListNamespaceKeysResult(
    public val aliasPrimaryConnectionString: String,
    public val aliasSecondaryConnectionString: String,
    public val keyName: String,
    public val primaryConnectionString: String,
    public val primaryKey: String,
    public val secondaryConnectionString: String,
    public val secondaryKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.ListNamespaceKeysResult): ListNamespaceKeysResult = ListNamespaceKeysResult(
            aliasPrimaryConnectionString = javaType.aliasPrimaryConnectionString(),
            aliasSecondaryConnectionString = javaType.aliasSecondaryConnectionString(),
            keyName = javaType.keyName(),
            primaryConnectionString = javaType.primaryConnectionString(),
            primaryKey = javaType.primaryKey(),
            secondaryConnectionString = javaType.secondaryConnectionString(),
            secondaryKey = javaType.secondaryKey(),
        )
    }
}
