@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The response from the List namespace operation.
 * @property action The IP Filter Action
 * @property ipMask IP Mask
 */
public data class NWRuleSetIpRulesResponse(
    public val action: String? = null,
    public val ipMask: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.NWRuleSetIpRulesResponse): NWRuleSetIpRulesResponse = NWRuleSetIpRulesResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            ipMask = javaType.ipMask().map({ args0 -> args0 }).orElse(null),
        )
    }
}
