@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties to configure retention settings for the  eventhub
 * @property cleanupPolicy Enumerates the possible values for cleanup policy
 * @property retentionTimeInHours Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If cleanupPolicy is Compact the returned value of this property is Long.MaxValue
 * @property tombstoneRetentionTimeInHours Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when cleanupPolicy is Compact. Consumer must complete reading the tombstone marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described by the tombstone marker within the compacted Event Hub
 */
public data class RetentionDescriptionResponse(
    public val cleanupPolicy: String? = null,
    public val retentionTimeInHours: Double? = null,
    public val tombstoneRetentionTimeInHours: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.RetentionDescriptionResponse): RetentionDescriptionResponse = RetentionDescriptionResponse(
            cleanupPolicy = javaType.cleanupPolicy().map({ args0 -> args0 }).orElse(null),
            retentionTimeInHours = javaType.retentionTimeInHours().map({ args0 -> args0 }).orElse(null),
            tombstoneRetentionTimeInHours = javaType.tombstoneRetentionTimeInHours().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
