@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU parameters supplied to the create namespace operation
 * @property capacity The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
 * @property name Name of this SKU.
 * @property tier The billing tier of this particular SKU.
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.SkuResponse): SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
