@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin

import com.pulumi.azurenative.extendedlocation.CustomLocationArgs.builder
import com.pulumi.azurenative.extendedlocation.kotlin.enums.HostType
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.CustomLocationPropertiesAuthenticationArgs
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.CustomLocationPropertiesAuthenticationArgsBuilder
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Custom Locations definition.
 * Azure REST API version: 2021-08-15. Prior API version in Azure Native 1.x: 2021-03-15-preview.
 * Other available API versions: 2021-08-31-preview.
 * ## Example Usage
 * ### Create/Update Custom Location
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customLocation = new AzureNative.ExtendedLocation.CustomLocation("customLocation", new()
 *     {
 *         Authentication = new AzureNative.ExtendedLocation.Inputs.CustomLocationPropertiesAuthenticationArgs
 *         {
 *             Type = "KubeConfig",
 *             Value = "<base64 KubeConfig>",
 *         },
 *         ClusterExtensionIds = new[]
 *         {
 *             "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedCluster/someCluster/Microsoft.KubernetesConfiguration/clusterExtensions/fooExtension",
 *         },
 *         DisplayName = "customLocationLocation01",
 *         HostResourceId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup/providers/Microsoft.ContainerService/managedClusters/cluster01",
 *         Identity = new AzureNative.ExtendedLocation.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.ExtendedLocation.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Namespace = "namespace01",
 *         ResourceGroupName = "testresourcegroup",
 *         ResourceName = "customLocation01",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/extendedlocation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := extendedlocation.NewCustomLocation(ctx, "customLocation", &extendedlocation.CustomLocationArgs{
 * 			Authentication: &extendedlocation.CustomLocationPropertiesAuthenticationArgs{
 * 				Type:  pulumi.String("KubeConfig"),
 * 				Value: pulumi.String("<base64 KubeConfig>"),
 * 			},
 * 			ClusterExtensionIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedCluster/someCluster/Microsoft.KubernetesConfiguration/clusterExtensions/fooExtension"),
 * 			},
 * 			DisplayName:    pulumi.String("customLocationLocation01"),
 * 			HostResourceId: pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup/providers/Microsoft.ContainerService/managedClusters/cluster01"),
 * 			Identity: &extendedlocation.IdentityArgs{
 * 				Type: pulumi.String(extendedlocation.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			Namespace:         pulumi.String("namespace01"),
 * 			ResourceGroupName: pulumi.String("testresourcegroup"),
 * 			ResourceName:      pulumi.String("customLocation01"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.extendedlocation.CustomLocation;
 * import com.pulumi.azurenative.extendedlocation.CustomLocationArgs;
 * import com.pulumi.azurenative.extendedlocation.inputs.CustomLocationPropertiesAuthenticationArgs;
 * import com.pulumi.azurenative.extendedlocation.inputs.IdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customLocation = new CustomLocation("customLocation", CustomLocationArgs.builder()
 *             .authentication(CustomLocationPropertiesAuthenticationArgs.builder()
 *                 .type("KubeConfig")
 *                 .value("<base64 KubeConfig>")
 *                 .build())
 *             .clusterExtensionIds("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedCluster/someCluster/Microsoft.KubernetesConfiguration/clusterExtensions/fooExtension")
 *             .displayName("customLocationLocation01")
 *             .hostResourceId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup/providers/Microsoft.ContainerService/managedClusters/cluster01")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .namespace("namespace01")
 *             .resourceGroupName("testresourcegroup")
 *             .resourceName("customLocation01")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:extendedlocation:CustomLocation customLocation01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ExtendedLocation/customLocations/{resourceName}
 * ```
 * @property authentication This is optional input that contains the authentication that should be used to generate the namespace.
 * @property clusterExtensionIds Contains the reference to the add-on that contains charts to deploy CRDs and operators.
 * @property displayName Display name for the Custom Locations location.
 * @property hostResourceId Connected Cluster or AKS Cluster. The Custom Locations RP will perform a checkAccess API for listAdminCredentials permissions.
 * @property hostType Type of host the Custom Locations is referencing (Kubernetes, etc...).
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property namespace Kubernetes namespace that will be created on the specified cluster.
 * @property provisioningState Provisioning State for the Custom Location.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Custom Locations name.
 * @property tags Resource tags.
 */
public data class CustomLocationArgs(
    public val authentication: Output<CustomLocationPropertiesAuthenticationArgs>? = null,
    public val clusterExtensionIds: Output<List<String>>? = null,
    public val displayName: Output<String>? = null,
    public val hostResourceId: Output<String>? = null,
    public val hostType: Output<Either<String, HostType>>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.extendedlocation.CustomLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.extendedlocation.CustomLocationArgs =
        com.pulumi.azurenative.extendedlocation.CustomLocationArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterExtensionIds(clusterExtensionIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .hostResourceId(hostResourceId?.applyValue({ args0 -> args0 }))
            .hostType(
                hostType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomLocationArgs].
 */
@PulumiTagMarker
public class CustomLocationArgsBuilder internal constructor() {
    private var authentication: Output<CustomLocationPropertiesAuthenticationArgs>? = null

    private var clusterExtensionIds: Output<List<String>>? = null

    private var displayName: Output<String>? = null

    private var hostResourceId: Output<String>? = null

    private var hostType: Output<Either<String, HostType>>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var namespace: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value This is optional input that contains the authentication that should be used to generate the namespace.
     */
    @JvmName("xhsbcshrejiaekvk")
    public suspend fun authentication(`value`: Output<CustomLocationPropertiesAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value Contains the reference to the add-on that contains charts to deploy CRDs and operators.
     */
    @JvmName("ulgnlperxcljtpcy")
    public suspend fun clusterExtensionIds(`value`: Output<List<String>>) {
        this.clusterExtensionIds = value
    }

    @JvmName("pviuiwbwjdflphth")
    public suspend fun clusterExtensionIds(vararg values: Output<String>) {
        this.clusterExtensionIds = Output.all(values.asList())
    }

    /**
     * @param values Contains the reference to the add-on that contains charts to deploy CRDs and operators.
     */
    @JvmName("npduwqayyssmmwlm")
    public suspend fun clusterExtensionIds(values: List<Output<String>>) {
        this.clusterExtensionIds = Output.all(values)
    }

    /**
     * @param value Display name for the Custom Locations location.
     */
    @JvmName("aghtheacfaeehrks")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Connected Cluster or AKS Cluster. The Custom Locations RP will perform a checkAccess API for listAdminCredentials permissions.
     */
    @JvmName("yqouhuqeppdfcwbn")
    public suspend fun hostResourceId(`value`: Output<String>) {
        this.hostResourceId = value
    }

    /**
     * @param value Type of host the Custom Locations is referencing (Kubernetes, etc...).
     */
    @JvmName("ydgnreyebwmwcxod")
    public suspend fun hostType(`value`: Output<Either<String, HostType>>) {
        this.hostType = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("keytmyjkocdcdvyv")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tehbqkghhopgasqq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Kubernetes namespace that will be created on the specified cluster.
     */
    @JvmName("grtgyrdqwfrwvlqn")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Provisioning State for the Custom Location.
     */
    @JvmName("sesmlppvfinthheu")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fuggyhebydvdiode")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Custom Locations name.
     */
    @JvmName("cidjbpnxvhecmlle")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bgcxsdwcfoacskqh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value This is optional input that contains the authentication that should be used to generate the namespace.
     */
    @JvmName("glwdtkssdgqtiiun")
    public suspend fun authentication(`value`: CustomLocationPropertiesAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument This is optional input that contains the authentication that should be used to generate the namespace.
     */
    @JvmName("gkditonfyqxkjhmh")
    public suspend fun authentication(argument: suspend CustomLocationPropertiesAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLocationPropertiesAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value Contains the reference to the add-on that contains charts to deploy CRDs and operators.
     */
    @JvmName("bqgpwpwyrlyomtxi")
    public suspend fun clusterExtensionIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterExtensionIds = mapped
    }

    /**
     * @param values Contains the reference to the add-on that contains charts to deploy CRDs and operators.
     */
    @JvmName("gfocacvgsmsdoqgd")
    public suspend fun clusterExtensionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterExtensionIds = mapped
    }

    /**
     * @param value Display name for the Custom Locations location.
     */
    @JvmName("vuopmdescwyoffqh")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Connected Cluster or AKS Cluster. The Custom Locations RP will perform a checkAccess API for listAdminCredentials permissions.
     */
    @JvmName("ftfaxoxfqkdjdgcg")
    public suspend fun hostResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostResourceId = mapped
    }

    /**
     * @param value Type of host the Custom Locations is referencing (Kubernetes, etc...).
     */
    @JvmName("dqwlcnswfcorjmni")
    public suspend fun hostType(`value`: Either<String, HostType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Type of host the Custom Locations is referencing (Kubernetes, etc...).
     */
    @JvmName("wdsnntntxhkehsho")
    public fun hostType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HostType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Type of host the Custom Locations is referencing (Kubernetes, etc...).
     */
    @JvmName("amiimtlppbcmfeda")
    public fun hostType(`value`: HostType) {
        val toBeMapped = Either.ofRight<String, HostType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("lkxlpqtdtrcpefwg")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("wlycqllccsrfoown")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dbbydntfymqoibul")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Kubernetes namespace that will be created on the specified cluster.
     */
    @JvmName("eyiabkmfqlbgxiud")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Provisioning State for the Custom Location.
     */
    @JvmName("klxicuuqyhptniyr")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dwdyhpcvgbpjhejn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Custom Locations name.
     */
    @JvmName("dmeejkprbyhjwyea")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tltxnfitvtomqfoa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dmyytahcnsriosjm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomLocationArgs = CustomLocationArgs(
        authentication = authentication,
        clusterExtensionIds = clusterExtensionIds,
        displayName = displayName,
        hostResourceId = hostResourceId,
        hostType = hostType,
        identity = identity,
        location = location,
        namespace = namespace,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
